import {useEffect} from 'react';

import {usePrevious} from 'utilities/hooks/usePrevious';

export default function useSyncBaggageToggleWithGlobalBaggageFilter(
    variantHasBaggage: boolean,
    baggageToggleIsActive: boolean,
    toggleBaggage: () => void,
): void {
    const prevHasBaggage = usePrevious(variantHasBaggage);

    useEffect(() => {
        if (prevHasBaggage && !variantHasBaggage && baggageToggleIsActive) {
            toggleBaggage();
        }
    }, [
        baggageToggleIsActive,
        variantHasBaggage,
        prevHasBaggage,
        toggleBaggage,
    ]);
}
