import {useEffect, useRef} from 'react';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

/**
 * Выставляет актуальный выбранный вариант при подгрузке цен,
 * переключении фильтров и тд.
 */
export default function useSyncSelectedVariant(
    cheapest: IResultAviaVariant,
    cheapestWithBaggage: IResultAviaVariant | null,
    setSelectedVariant: (variant: IResultAviaVariant) => void,
): void {
    const prevCheapestRef = useRef<IResultAviaVariant | null>(null);
    const prevCheapestWithBaggageRef = useRef<IResultAviaVariant | null>(null);

    useEffect(() => {
        if (
            cheapest !== prevCheapestRef.current ||
            cheapestWithBaggage !== prevCheapestWithBaggageRef.current
        ) {
            setSelectedVariant(cheapest);

            prevCheapestRef.current = cheapest;
            prevCheapestWithBaggageRef.current = cheapestWithBaggage;
        }
    }, [cheapest, cheapestWithBaggage, setSelectedVariant]);
}
