import {FunctionComponent} from 'react';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import SegmentSkeleton from './components/SegmentSkeleton/SegmentSkeleton';
import PriceSkeleton from './components/PriceSkeleton/PriceSkeleton';

import cx from './AviaResultVariantSkeleton.scss';

interface IAviaResultVariantSkeletonProps {
    isRoundTrip: boolean;
}

const AviaResultVariantSkeleton: FunctionComponent<IAviaResultVariantSkeletonProps> =
    ({isRoundTrip}) => {
        const deviceType = useDeviceType();
        const {isDesktop} = deviceType;

        return (
            <Flex
                className={cx('root', deviceModDesktop('root', deviceType))}
                between="2"
                inline
                alignItems={isDesktop ? 'center' : 'start'}
            >
                {isDesktop && (
                    <div className={cx('titleContainer')}>
                        <TextSkeleton className={cx('title')} size="m" />
                    </div>
                )}
                <Box between={isDesktop ? 3 : 4} className={cx('segments')}>
                    <SegmentSkeleton deviceType={deviceType} />
                    {isRoundTrip && <SegmentSkeleton deviceType={deviceType} />}
                </Box>
                <PriceSkeleton
                    className={cx('price')}
                    deviceType={deviceType}
                />
            </Flex>
        );
    };

export default AviaResultVariantSkeleton;
