import React from 'react';

import Flex from 'components/Flex/Flex';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import FlightSkeleton from 'projects/avia/components/AviaResultVariantSkeleton/components/MobileExpSkeleton/components/FlightSkeleton/FlightSkeleton';
import VariantSkeleton from 'projects/avia/components/AviaResultVariantSkeleton/components/MobileExpSkeleton/components/VariantSkeleton/VariantSkeleton';

import cx from './MobileExpSkeleton.scss';

interface IMobileExpSkeletonProps {
    isRoundTrip: boolean;
}

const MobileExpSkeleton: React.FC<IMobileExpSkeletonProps> = props => {
    const {isRoundTrip} = props;

    return (
        <Flex className={cx('root')} flexDirection="column">
            <Flex alignItems="center" between={3} inline nowrap>
                <Skeleton className={cx('logo')} />

                <TextSkeleton className={cx('title')} />
            </Flex>

            <FlightSkeleton className={cx('flight')} />

            {isRoundTrip && <FlightSkeleton className={cx('flight')} />}

            <TextSkeleton className={cx('carryOn')} size="s" />

            <TextSkeleton className={cx('baggage')} size="s" />

            <VariantSkeleton className={cx('variant')} />
        </Flex>
    );
};

export default React.memo(MobileExpSkeleton);
