import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './FlightSkeleton.scss';

interface IFlightSkeletonProps extends IWithClassName {}

const FlightSkeleton: React.FC<IFlightSkeletonProps> = props => {
    const {className} = props;

    return (
        <div className={className}>
            <Flex justifyContent="space-between">
                <TextSkeleton className={cx('time')} />
                <TextSkeleton className={cx('time')} />
            </Flex>

            <Flex justifyContent="space-between">
                <TextSkeleton className={cx('station')} size="s" />
                <TextSkeleton className={cx('duration')} size="s" />
                <TextSkeleton className={cx('station')} size="s" />
            </Flex>
        </div>
    );
};

export default React.memo(FlightSkeleton);
