import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './VariantSkeleton.scss';

interface IVariantSkeletonProps extends IWithClassName {}

const VariantSkeleton: React.FC<IVariantSkeletonProps> = props => {
    const {className} = props;

    return (
        <Flex
            className={cx(className)}
            alignItems="center"
            justifyContent="space-between"
        >
            <div>
                <TextSkeleton className={cx('price')} size="l" />
                <TextSkeleton className={cx('partner')} size="s" />
            </div>

            <ButtonSkeleton className={cx('button')} size="l" />
        </Flex>
    );
};

export default React.memo(VariantSkeleton);
