import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './PriceSkeleton.scss';

interface IPriceSkeletonProps extends IWithClassName, IWithDeviceType {}

const PriceSkeleton: FunctionComponent<IPriceSkeletonProps> = ({
    className,
    deviceType,
}) => (
    <Flex
        className={cx(deviceMods('root', deviceType), className)}
        flexDirection="column"
        alignItems="flex-end"
    >
        <TextSkeleton
            className={cx('price')}
            size={deviceType.isMobile ? 'l' : 'xl'}
        />
        {deviceType.isDesktop && (
            <TextSkeleton className={cx('description')} size="xxs" />
        )}
        <ButtonSkeleton
            className={cx('button')}
            size={deviceType.isMobile ? 'l' : 'm'}
        />
    </Flex>
);

export default PriceSkeleton;
