import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceModDesktop} from 'utilities/stylesUtils';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './SegmentSkeleton.scss';

interface ISegmentSkeletonProps extends IWithClassName, IWithDeviceType {}

const SegmentSkeleton: FunctionComponent<ISegmentSkeletonProps> = ({
    className,
    deviceType,
}) => {
    return (
        <Flex
            className={cx(deviceModDesktop('root', deviceType), className)}
            between="3"
            inline
            justifyContent="space-between"
        >
            <TextSkeleton className={cx('timeMarker')} size="m" />
            <TextSkeleton className={cx('timeMarker')} size="m" />
        </Flex>
    );
};

export default SegmentSkeleton;
