import React, {ReactNode} from 'react';

import {useMobile} from 'utilities/hooks/useMobile';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CheckButton from 'components/CheckButton/CheckButton';

import cx from './AviaSearchFilterWithAdditionalBlock.scss';

interface IAviaSearchFilterWithAdditionalBlockProps extends IWithQaAttributes {
    checked: boolean;
    disabled: boolean;
    onChange: () => void;
    children?: ReactNode;
    additionalBlock?: ReactNode;
    isNewFilters?: boolean;
}

const AviaSearchFilterWithAdditionalBlock: React.FC<IAviaSearchFilterWithAdditionalBlockProps> =
    ({
        isNewFilters,
        children,
        additionalBlock,
        checked,
        disabled,
        onChange,
        ...rest
    }) => {
        const isMobile = useMobile();

        return (
            <CheckButton
                size={isMobile ? 'l' : 'm-inset'}
                checked={checked}
                disabled={disabled}
                onClick={onChange}
                width={isMobile ? 'max' : 'auto'}
                {...prepareQaAttributes(rest)}
            >
                <span
                    className={cx(
                        'avia-filter-with-additional-block',
                        isMobile && 'avia-filter-with-additional-block_mobile',
                    )}
                >
                    <span>{children}</span>
                    {Boolean(additionalBlock) && (
                        <span
                            className={cx(
                                'avia-filter-with-additional-block__additional',
                                !isNewFilters &&
                                    isMobile &&
                                    'avia-filter-with-additional-block__additional_mobile',
                            )}
                        >
                            {additionalBlock}
                        </span>
                    )}
                </span>
            </CheckButton>
        );
    };

export default AviaSearchFilterWithAdditionalBlock;
