import {useCallback} from 'react';

import {ITDPartner} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import Checkbox from 'components/Checkbox/Checkbox';
import AviaPartnerLogo from 'projects/avia/components/PartnerLogo/PartnerLogo';

import cx from './AviaPartnerCheckbox.scss';

interface IAviaPartnerCheckboxProps {
    partner: ITDPartner;
    checked: boolean;
    disabled: boolean;
    onChange(partnerCode: string, checked: boolean): void;
}

export function AviaPartnerCheckbox({
    checked,
    disabled,
    onChange,
    partner,
}: IAviaPartnerCheckboxProps) {
    const handleChange = useCallback(
        (event: any) => {
            onChange(partner.code, event.target.checked);
        },
        [onChange, partner.code],
    );

    return (
        <Checkbox
            className={cx('root')}
            checked={checked}
            size="m"
            label={
                <AviaPartnerLogo
                    partner={partner}
                    size="s"
                    className={cx('logo', disabled && cx('disabled'))}
                />
            }
            disabled={disabled}
            onChange={handleChange}
        />
    );
}
