import React, {useCallback} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaPartnersFilter} from 'projects/avia/lib/hooks/filters/partners';

import * as i18nBlock from 'i18n/avia-search';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import FilterHeader from 'components/FiltersBottomSheet/components/FilterHeader/FilterHeader';

import {AviaSearchPartnersFilterPopupNoConnected} from './AviaSearchPartnersFilterPopupNoConnected';

interface IAviaSearchPartnersFilterProps extends IWithQaAttributes {
    isActive: boolean;
    showHeader?: boolean;
    onChange?: () => void;
}

const AviaSearchPartnersFilter: React.FC<IAviaSearchPartnersFilterProps> = ({
    isActive,
    showHeader,
    onChange,
    ...rest
}) => {
    const partnersFilter = useAviaPartnersFilter();

    const handleOnReset = useCallback(() => {
        onChange?.();

        partnersFilter.reset();
    }, [onChange, partnersFilter]);

    return (
        <DropdownFilter
            label={i18nBlock.filterDotPartnersDotFilterButtonText()}
            checked={isActive}
            {...prepareQaAttributes(rest)}
        >
            {showHeader && (
                <FilterHeader
                    label={i18nBlock.filterDotPartnersDotFilterButtonText()}
                    buttonResetDisabled={!partnersFilter.filter.isActive}
                    onReset={handleOnReset}
                />
            )}
            <AviaSearchPartnersFilterPopupNoConnected
                partnersFilter={partnersFilter}
                onChange={onChange}
            />
        </DropdownFilter>
    );
};

export default React.memo(AviaSearchPartnersFilter);
