import {FC, useCallback, useMemo} from 'react';
import {values} from 'lodash';

import {TAviaSearchPartnersFilter} from 'reducers/avia/search/results/filters/reducer';

import {compareStrings} from 'projects/avia/lib/comparators/compareStrings';
import {IUseAviaPartnersFilter} from 'projects/avia/lib/hooks/filters/partners';

import {AviaSearchPartnersFilterPopup} from './AviaSearchPartnersFilterPopup';

interface IAviaSearchPartnersFilterPopupNoConnectedProps {
    partnersFilter: IUseAviaPartnersFilter;
    onChange?: () => void;
}

export const AviaSearchPartnersFilterPopupNoConnected: FC<IAviaSearchPartnersFilterPopupNoConnectedProps> =
    ({partnersFilter, onChange}) => {
        const {
            filter: {value, viewData},
            handle,
        } = partnersFilter;
        const {disabledPartners, partners} = viewData;
        const sortedPartners = useMemo(
            () =>
                values(partners).sort((a, b) =>
                    compareStrings(a.title, b.title),
                ),
            [partners],
        );

        const handleOnChange = useCallback(
            (nextValue: TAviaSearchPartnersFilter) => {
                onChange?.();

                handle(nextValue);
            },
            [handle, onChange],
        );

        return (
            <AviaSearchPartnersFilterPopup
                partners={sortedPartners}
                disabledPartners={disabledPartners}
                value={value}
                onChange={handleOnChange}
            />
        );
    };
