import React, {ReactNode} from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useExperiments} from 'utilities/hooks/useExperiments';

import * as keyset from 'i18n/avia-search';

import Box from 'components/Box/Box';
import ProgressBar, {
    IProgressBarProps,
} from 'components/ProgressBar/ProgressBar';

import cx from './AviaSearchProgressBar.scss';

type TAviaSearchProgressBar = Omit<IProgressBarProps, 'contentClassName'>;

export const AviaSearchProgressBar: React.FC<TAviaSearchProgressBar> =
    props => {
        const {all, current} = props;
        const deviceType = useDeviceType();
        const {aviaNewTouchFilters} = useExperiments();

        const isThinProgressBar = Boolean(
            aviaNewTouchFilters && deviceType.isMobile,
        );

        return (
            <ProgressBar
                {...props}
                contentClassName={cx(
                    'content',
                    deviceMods('content', deviceType),
                )}
                type={isThinProgressBar ? 'thin' : 'full'}
            >
                {deviceType.isMobile
                    ? renderMobile(all, current, isThinProgressBar)
                    : renderDesktop(all, current)}
            </ProgressBar>
        );
    };

function renderMobile(
    all: number,
    current: number,
    isThinProgressBar: boolean,
): ReactNode {
    if (isThinProgressBar) {
        return null;
    }

    if (all) {
        return (
            <Box textSize="m" textWeight="normal">
                {keyset.progressbarDotTitle({
                    current,
                    all,
                })}
            </Box>
        );
    }

    return <Box textSize="m">{keyset.progressbarDotSubtitleDashShort()}</Box>;
}

function renderDesktop(all: number, current: number): ReactNode {
    return (
        <>
            {Boolean(all) && (
                <Box textSize="l" textWeight="medium">
                    {keyset.progressbarDotTitle({
                        current,
                        all,
                    })}
                </Box>
            )}
            <Box textSize="m">{keyset.progressbarDotSubtitle()}</Box>
        </>
    );
}
