import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useAviaPlusPointsFilter} from 'projects/avia/lib/hooks/filters/plusPoints';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/avia-search';

import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import CheckButton from 'components/CheckButton/CheckButton';
import {IButtonProps} from 'components/Button/Button';

interface IAviaSearchResultPlusPointsFilterProps extends IWithClassName {
    size?: IButtonProps['size'];
}

export const AviaSearchResultPlusPointsFilter: React.FC<IAviaSearchResultPlusPointsFilterProps> =
    props => {
        const {size, className} = props;
        const deviceType = useDeviceType();
        const [
            {
                value: {enabled},
            },
            setPlusPointsFilter,
        ] = useAviaPlusPointsFilter();

        return (
            <CheckButton
                className={className}
                onClick={setPlusPointsFilter}
                icon={<YandexPlusSignColorGradientS />}
                checked={enabled}
                size={size}
            >
                {!deviceType.isMobile && i18nBlock.sortPlusPointsDesktop()}
            </CheckButton>
        );
    };
