import {useCallback} from 'react';

import {TAviaSearchAirportsFilterKeys} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaStation} from 'selectors/avia/utils/denormalization/station';

import {useMobile} from 'utilities/hooks/useMobile';

import Box from 'components/Box/Box';

import {AirportsStationCheckbox} from './AirportsStationCheckbox';

interface IAirportsFilterDirectionGroupProps {
    type: TAviaSearchAirportsFilterKeys;
    stations: IResultAviaStation[];
    segmentIdx: number;
    segmentFilter: number[] | undefined;
    disabledStations?: Record<number, boolean>;
    label: string;
    onChange(
        direction: TAviaSearchAirportsFilterKeys,
        stationId: number,
        segmentIdx: number,
        checked: boolean,
    ): void;
}

export function AirportsFilterDirectionGroup({
    type,
    stations,
    segmentIdx,
    segmentFilter,
    disabledStations = {},
    label,
    onChange,
}: IAirportsFilterDirectionGroupProps) {
    const isMobile = useMobile();
    const handleChange = useCallback(
        (checked: boolean, station: IResultAviaStation) => {
            onChange(type, station.id, segmentIdx, checked);
        },
        [onChange, segmentIdx, type],
    );

    const renderStation = (station: IResultAviaStation) => {
        const isChecked = segmentFilter
            ? segmentFilter.includes(station.id)
            : false;

        return (
            <AirportsStationCheckbox
                checked={isChecked}
                disabled={disabledStations[station.id]}
                onChange={handleChange}
                station={station}
                key={station.id}
            />
        );
    };

    return (
        <div>
            <Box textWeight="normal" textSize="m" below={3}>
                {label}
            </Box>
            <Box between={isMobile ? 3 : 2}>{stations.map(renderStation)}</Box>
        </div>
    );
}
