import {FC, useCallback, useMemo} from 'react';

import {IAviaSearchSegmentsDirectionAirportsFilter} from 'reducers/avia/search/results/filters/reducer';

import {stationMapsToStations} from 'projects/avia/lib/search/stationMapsToStations';
import {IUseAviaAirportsFilter} from 'projects/avia/lib/hooks/filters/airports';

import {AirportsFilterPopup} from './AirportsFilterPopup';

interface IAirportsFilterPopupNoConnectedProps {
    airportsFilter: IUseAviaAirportsFilter;
    onChange?: () => void;
}

export const AirportsFilterPopupNoConnected: FC<IAirportsFilterPopupNoConnectedProps> =
    ({airportsFilter, onChange}) => {
        const {
            filter: {value, viewData},
            handleDirectionAirports: handle,
        } = airportsFilter;
        const stationsBySegment = useMemo(
            () => viewData.stations.map(stationMapsToStations),
            [viewData.stations],
        );

        const handleOnChange = useCallback(
            (nextValue: IAviaSearchSegmentsDirectionAirportsFilter[]) => {
                onChange?.();

                handle(nextValue);
            },
            [handle, onChange],
        );

        return (
            <AirportsFilterPopup
                stationsBySegment={stationsBySegment}
                value={value}
                onChange={handleOnChange}
                disabledStations={viewData.disabledStations}
                settlements={viewData.settlements}
            />
        );
    };
