import React, {useCallback} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaAirportsFilter} from 'projects/avia/lib/hooks/filters/airports';

import * as i18nBlock from 'i18n/avia-search';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import FilterHeader from 'components/FiltersBottomSheet/components/FilterHeader/FilterHeader';

import {AirportsFilterPopupNoConnected} from './AirportsFilterPopupNoConnected';

interface IAviaSearchResultsAirportsFilterProps extends IWithQaAttributes {
    isActive: boolean;
    showHeader?: boolean;
    onChange?: () => void;
}

const AviaSearchResultsAirportsFilter: React.FC<IAviaSearchResultsAirportsFilterProps> =
    ({isActive, showHeader, onChange, ...rest}) => {
        const airportsFilter = useAviaAirportsFilter();

        const handleOnReset = useCallback(() => {
            onChange?.();

            airportsFilter.resetDirectionAirports();
        }, [airportsFilter, onChange]);

        return (
            <DropdownFilter
                label={i18nBlock.filterDotAirportsDotTitle()}
                checked={isActive}
                {...prepareQaAttributes(rest)}
            >
                {showHeader && (
                    <FilterHeader
                        label={i18nBlock.filterDotAirportsDotTitle()}
                        buttonResetDisabled={
                            !airportsFilter.filter.directionsCount
                        }
                        onReset={handleOnReset}
                    />
                )}
                <AirportsFilterPopupNoConnected
                    airportsFilter={airportsFilter}
                    onChange={onChange}
                />
            </DropdownFilter>
        );
    };

export default React.memo(AviaSearchResultsAirportsFilter);
