import React from 'react';

import IPrice from 'utilities/currency/PriceInterface';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-search';

import Price from 'components/Price/Price';
import CheckButtonWithAdditionalBlock from 'components/CheckButtonWithAdditionalBlock/CheckButtonWithAdditionalBlock';

interface IAviaSearchResultsBaggageFilterProps extends IWithQaAttributes {
    checked: boolean;
    onChange: () => void;
    price?: IPrice | null;
    isNewFilters?: boolean;
}

export const AviaSearchResultsBaggageFilter: React.FC<IAviaSearchResultsBaggageFilterProps> =
    ({isNewFilters, checked, onChange, price, ...rest}) => {
        const additionalBlock = price ? (
            <Price isFrom {...price} />
        ) : (
            i18nBlock.filterDotNoDashFlights()
        );

        return (
            <CheckButtonWithAdditionalBlock
                checked={checked}
                disabled={price === null && !checked}
                onChange={onChange}
                additionalBlock={price !== undefined && additionalBlock}
                isNewFilters={isNewFilters}
                {...prepareQaAttributes(rest)}
            >
                {i18nBlock.filterDotWithDashBaggage()}
            </CheckButtonWithAdditionalBlock>
        );
    };
