import React from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaBaggageFilter} from 'projects/avia/lib/hooks/filters/baggage';

import {AviaSearchResultsBaggageFilterNoConnected} from 'projects/avia/components/AviaSearchResultsBaggageFilter/AviaSearchResultsBaggageFilterNoConnected';

interface IAviaSearchResultsBaggageFilterConnectedProps
    extends IWithQaAttributes {
    isNewFilters?: boolean;
    onChange?: () => void;
}

export const AviaSearchResultsBaggageFilterConnected: React.FC<IAviaSearchResultsBaggageFilterConnectedProps> =
    ({isNewFilters, onChange, ...rest}) => {
        const baggageFilter = useAviaBaggageFilter();

        return (
            <AviaSearchResultsBaggageFilterNoConnected
                baggageFilter={baggageFilter}
                isNewFilters={isNewFilters}
                onChange={onChange}
                {...prepareQaAttributes(rest)}
            />
        );
    };
