import React, {useCallback} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {IUseAviaBaggageFilter} from 'projects/avia/lib/hooks/filters/baggage';

import {AviaSearchResultsBaggageFilter} from './AviaSearchResultsBaggageFilter';

interface IAviaSearchResultsBaggageFilterNoConnectedProps
    extends IWithQaAttributes {
    isNewFilters?: boolean;
    baggageFilter: IUseAviaBaggageFilter;
    onChange?: () => void;
}

export const AviaSearchResultsBaggageFilterNoConnected: React.FC<IAviaSearchResultsBaggageFilterNoConnectedProps> =
    ({isNewFilters, baggageFilter, onChange, ...rest}) => {
        const {
            filter: {value, viewData},
            handle,
        } = baggageFilter;

        const handleOnChange = useCallback(() => {
            onChange?.();

            handle();
        }, [handle, onChange]);

        return (
            <AviaSearchResultsBaggageFilter
                onChange={handleOnChange}
                checked={value.enabled}
                price={viewData.price}
                isNewFilters={isNewFilters}
                {...prepareQaAttributes(rest)}
            />
        );
    };
