import {FC, useCallback, useMemo} from 'react';

import {EOneWay} from 'server/services/AviaSearchService/types/IAviaParams';

import {
    EAviaSearchTransferFilter,
    TAviaSearchCompanyFilter,
} from 'reducers/avia/search/results/filters/reducer';

import {IUseAviaCompanyFilter} from 'projects/avia/lib/hooks/filters/company';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {isEnabled} from 'utilities/flags/flags';
import {IUseAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';

import {AviaCompanyFilterPopup} from './AviaCompanyFilterPopup';

interface IAviaCompanyFilterPopupNoConnectedProps extends IWithQaAttributes {
    companyFilter: IUseAviaCompanyFilter;
    transfersFilter: IUseAviaTransfersFilter;
    oneway: EOneWay;
    onChange?: () => void;
}

export const AviaCompanyFilterPopupNoConnected: FC<IAviaCompanyFilterPopupNoConnectedProps> =
    ({companyFilter, transfersFilter, oneway, onChange, ...rest}) => {
        const {
            filter: {value, viewData},
            handle,
        } = companyFilter;
        const disableCombinations = useMemo(() => {
            const isNoTransfers = isEnabled(
                transfersFilter.filter.value.value,
                EAviaSearchTransferFilter.NO_TRANSFERS,
            );

            return oneway === EOneWay.ONE_WAY && isNoTransfers;
        }, [oneway, transfersFilter]);

        const handleOnChange = useCallback(
            (nextValue: TAviaSearchCompanyFilter) => {
                onChange?.();

                handle(nextValue);
            },
            [handle, onChange],
        );

        return (
            <AviaCompanyFilterPopup
                value={value}
                allCompanies={viewData.allCompanies}
                allAlliences={viewData.allAlliences}
                availableCompanies={viewData.availableCompanies}
                availableAlliences={viewData.availableAlliences}
                companiesByAllienceMap={viewData.companiesByAllienceMap}
                onChange={handleOnChange}
                disableCombinations={disableCombinations}
                {...prepareQaAttributes(rest)}
            />
        );
    };
