import React, {useCallback} from 'react';
import {useSelector} from 'react-redux';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaCompanyFilter} from 'projects/avia/lib/hooks/filters/company';
import {useAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';

import * as i18nBlock from 'i18n/avia-search';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import FilterHeader from 'components/FiltersBottomSheet/components/FilterHeader/FilterHeader';

import {AviaCompanyFilterPopupNoConnected} from './AviaCompanyFilterPopupNoConnected';

interface IAviaSearchResultsCompanyFilterProps extends IWithQaAttributes {
    isActive: boolean;
    count: number;
    showHeader?: boolean;
    onChange?: () => void;
}

const AviaSearchResultsCompanyFilter: React.FC<IAviaSearchResultsCompanyFilterProps> =
    ({isActive, count, showHeader, onChange, ...rest}) => {
        const companyFilter = useAviaCompanyFilter();
        const transfersFilter = useAviaTransfersFilter();
        const {oneway} = useSelector(getAviaContext);

        const handleOnReset = useCallback(() => {
            onChange?.();

            companyFilter.reset();
        }, [companyFilter, onChange]);

        return (
            <DropdownFilter
                label={i18nBlock.filterDotCompanyDotFilterButtonText({
                    count,
                })}
                checked={isActive}
                {...prepareQaAttributes(rest)}
            >
                {showHeader && (
                    <FilterHeader
                        label={i18nBlock.filterDotCompanyDotFilterButtonText({
                            count: 0,
                        })}
                        buttonResetDisabled={!companyFilter.filter.isActive}
                        onReset={handleOnReset}
                    />
                )}
                <AviaCompanyFilterPopupNoConnected
                    companyFilter={companyFilter}
                    transfersFilter={transfersFilter}
                    oneway={oneway}
                    onChange={onChange}
                    {...prepareQaAttributes(rest)}
                />
            </DropdownFilter>
        );
    };

export default React.memo(AviaSearchResultsCompanyFilter);
