import React from 'react';
import {useSelector} from 'react-redux';

import {aviaFiltersStateSelector} from 'selectors/avia/search/filters/activeFilters';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import AviaSearchResultsSortingFilterConnected from '../AviaSearchResultsSortingFilter/AviaSearchResultsSortingFilterConnected';
import AviaSearchResultsTransferFilter from '../AviaSearchResultsTransferFilter/AviaSearchResultsTransferFilter';
import AviaSearchResultsTimeFilter from '../AviaSearchResultsTimeFilter/AviaSearchResultsTimeFilter';
import AviaSearchResultsCompanyFilter from '../AviaSearchResultsCompanyFilter/AviaSearchResultsCompanyFilter';
import AviaSearchResultsAirportsFilter from '../AviaSearchResultsAirportsFilter/AviaSearchResultsAirportsFilter';
import AviaSearchPartnersFilter from '../AviaSearchPartnersFilter/AviaSearchPartnersFilter';
import {AviaSearchResultsBaggageFilterConnected} from '../AviaSearchResultsBaggageFilter/AviaSearchResultsBaggageFilterConnected';
import {AviaSearchResultsNoTransferFilterFilterConnected} from '../AviaSearchResultsNoTransferFilter/AviaSearchResultsNoTransferFilterConnected';
import {usePartnersFilterIsVisible} from './hooks/usePartnersFilterIsVisible';

import cx from './AviaSearchResultsFilters.scss';

interface IAviaSearchResultsFiltersProps extends IWithQaAttributes {
    isRoundtrip?: boolean;
    onChange?: () => void;
}

interface IAviaPartnerFilterProps extends IWithQaAttributes {
    isActive: boolean;
    showHeader?: boolean;
    onChange?: () => void;
}

const AviaPartnerFilter: React.FC<IAviaPartnerFilterProps> = props => {
    const {isActive, showHeader, onChange} = props;

    return (
        <div className={cx('filter')}>
            <AviaSearchPartnersFilter
                isActive={isActive}
                showHeader={showHeader}
                onChange={onChange}
                {...prepareQaAttributes(props)}
            />
        </div>
    );
};

export const AviaSearchResultsFilters: React.FC<IAviaSearchResultsFiltersProps> =
    ({isRoundtrip, onChange, ...props}) => {
        const filtersState = useSelector(aviaFiltersStateSelector);
        const companyFilterValue = useSelector(aviaCompanyFilterSelector.value);

        const isPartnersFilterVisible = usePartnersFilterIsVisible();

        return (
            <>
                <div className={cx('filter')}>
                    <AviaSearchResultsSortingFilterConnected
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'sorting',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsNoTransferFilterFilterConnected
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'no-transfer',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsBaggageFilterConnected
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'baggage',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsTransferFilter
                        isActive={filtersState.transfer}
                        showHeader
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'transfers',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsTimeFilter
                        isActive={filtersState.time}
                        isRoundtrip={Boolean(isRoundtrip)}
                        showHeader
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'time',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsAirportsFilter
                        isActive={filtersState.airports}
                        showHeader
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'airports',
                        })}
                    />
                </div>

                <div className={cx('filter')}>
                    <AviaSearchResultsCompanyFilter
                        isActive={filtersState.company}
                        count={companyFilterValue.companiesIds.length}
                        showHeader
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'companies',
                        })}
                    />
                </div>

                {isPartnersFilterVisible && (
                    <AviaPartnerFilter
                        isActive={filtersState.partners}
                        showHeader
                        onChange={onChange}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'partners',
                        })}
                    />
                )}
            </>
        );
    };
