import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/avia-search';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import LinkButton from 'components/LinkButton/LinkButton';

import cx from './FilterHeader.scss';

interface IFilterHeaderProps {
    label: string;
    buttonResetDisabled?: boolean;
    onReset?: () => void;
    withReset?: boolean;
}

const FilterHeader: React.FC<IFilterHeaderProps> = ({
    label,
    buttonResetDisabled,
    onReset,
    withReset = true,
}) => {
    const deviceType = useDeviceType();

    return (
        <Flex
            className={cx('header', deviceMods('header', deviceType))}
            justifyContent="space-between"
        >
            <Text
                whiteSpace={deviceType.isDesktop ? 'nowrap' : 'normal'}
                size="l"
                weight="bold"
            >
                {label}
            </Text>
            {withReset && (
                <LinkButton
                    className={cx(
                        'buttonReset',
                        buttonResetDisabled && 'buttonReset_disabled',
                    )}
                    disabled={buttonResetDisabled}
                    onClick={onReset}
                >
                    {i18nBlock.filtersDotCancel()}
                </LinkButton>
            )}
        </Flex>
    );
};

export default FilterHeader;
