import React from 'react';
import {useSelector} from 'react-redux';

import {aviaAeroflotPlusSelector} from 'projects/avia/selectors/aviaAeroflotPlusEnabledSelector';
import {hasVariantWithPlusPointsSelector} from 'selectors/avia/search/hasVariantWithPlusPointsSelector';

import {useAviaTotalFilters} from 'projects/avia/lib/hooks/filters/total';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useExperiments} from 'utilities/hooks/useExperiments';

import Box from 'components/Box/Box';
import {AviaSearchResultsNoTransferFilterFilterNoConnected} from 'projects/avia/components/AviaSearchResultsNoTransferFilter/AviaSearchResultsNoTransferFilterNoConnected';
import {AviaSearchResultsBaggageFilterNoConnected} from 'projects/avia/components/AviaSearchResultsBaggageFilter/AviaSearchResultsBaggageFilterNoConnected';

import {AviaSearchResultPlusPointsFilter} from '../../../AviaSearchResultPlusPointsFilter/AviaSearchResultPlusPointsFilter';
import SearchFiltersTriggerButton from '../SearchFiltersTriggerButton/SearchFiltersTriggerButton';

interface IFiltersBarMobileProps extends IWithQaAttributes {
    isRoundtrip: boolean;
    onChange?: () => void;
}

const FiltersBarMobile: React.FC<IFiltersBarMobileProps> = ({
    isRoundtrip,
    onChange,
}) => {
    const aviaAeroflotPlus = useSelector(aviaAeroflotPlusSelector);
    const hasVariantWithPlusPoints = useSelector(
        hasVariantWithPlusPointsSelector,
    );
    const totalFilters = useAviaTotalFilters();
    const {aviaNewTouchFilters} = useExperiments();

    const searchFiltersTrigger = (!aviaAeroflotPlus ||
        !hasVariantWithPlusPoints) && (
        <SearchFiltersTriggerButton
            isRoundtrip={isRoundtrip}
            totalFilters={totalFilters}
        />
    );

    return (
        <Box
            between="2"
            inline
            nowrap
            {...prepareQaAttributes('avia-touch-filters')}
        >
            {aviaNewTouchFilters && searchFiltersTrigger}

            {aviaAeroflotPlus && hasVariantWithPlusPoints && (
                <AviaSearchResultPlusPointsFilter size="l" />
            )}

            <AviaSearchResultsNoTransferFilterFilterNoConnected
                transfersFilter={totalFilters.transfersFilter}
                onChange={onChange}
            />

            <AviaSearchResultsBaggageFilterNoConnected
                baggageFilter={totalFilters.baggageFilter}
                onChange={onChange}
            />

            {!aviaNewTouchFilters && searchFiltersTrigger}
        </Box>
    );
};

export default FiltersBarMobile;
