import {FunctionComponent} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useExperiments} from 'utilities/hooks/useExperiments';

import Box from 'components/Box/Box';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import FiltersBarMobile from '../FiltersBarMobile/FiltersBarMobile';

import cx from './SearchResultsFiltersMobile.scss';

export interface IAviaSearchResultsFiltersMobileProps
    extends IWithQaAttributes {
    isRoundtrip: boolean;
    isSkeletons?: boolean;
    onChange?: () => void;
}

const SearchResultsFiltersMobile: FunctionComponent<IAviaSearchResultsFiltersMobileProps> =
    ({isRoundtrip, isSkeletons, onChange, ...rest}) => {
        const {aviaNewTouchFilters} = useExperiments();

        if (isSkeletons) {
            return (
                <Box
                    className={cx('skeletons')}
                    between="2"
                    inline
                    nowrap
                    {...prepareQaAttributes(rest)}
                >
                    <ButtonSkeleton
                        className={cx({
                            buttonSkeleton: !aviaNewTouchFilters,
                            buttonSkeleton_square: aviaNewTouchFilters,
                        })}
                        size="l"
                    />
                    <ButtonSkeleton className={cx('buttonSkeleton')} size="l" />
                    <ButtonSkeleton
                        className={cx({
                            buttonSkeleton: aviaNewTouchFilters,
                            buttonSkeleton_square: !aviaNewTouchFilters,
                        })}
                        size="l"
                    />
                </Box>
            );
        }

        return (
            <FiltersBarMobile isRoundtrip={isRoundtrip} onChange={onChange} />
        );
    };

export default SearchResultsFiltersMobile;
