import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';

import featuresSelector from 'selectors/common/featuresSelector';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';
import {useUserInfo} from 'utilities/hooks/useUserInfo';

export function usePartnersFilterIsVisible(): Boolean {
    const userInfo = useUserInfo();
    const location = useLocation();
    const {enablePartnersFilter} = useSelector(featuresSelector);
    const query = getQueryByLocation(location);

    return Boolean(
        userInfo.isYandexNetwork ||
            ('isStaff' in userInfo &&
                (userInfo.isStaff || userInfo.isBetaTest)) ||
            query.testenv ||
            enablePartnersFilter,
    );
}
