import React from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';

import {AviaSearchResultsNoTransferFilterFilterNoConnected} from 'projects/avia/components/AviaSearchResultsNoTransferFilter/AviaSearchResultsNoTransferFilterNoConnected';

interface IAviaSearchResultsNoTransferFilterFilterConnectedProps
    extends IWithQaAttributes {
    isNewFilters?: boolean;
    onChange?: () => void;
}

export const AviaSearchResultsNoTransferFilterFilterConnected: React.FC<IAviaSearchResultsNoTransferFilterFilterConnectedProps> =
    ({isNewFilters, onChange, ...rest}) => {
        const transfersFilter = useAviaTransfersFilter();

        return (
            <AviaSearchResultsNoTransferFilterFilterNoConnected
                transfersFilter={transfersFilter}
                isNewFilters={isNewFilters}
                onChange={onChange}
                {...prepareQaAttributes(rest)}
            />
        );
    };
