import React, {useCallback} from 'react';

import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import {disable, enable, isEnabled} from 'utilities/flags/flags';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {IUseAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';

import {AviaSearchResultsNoTransferFilter} from 'projects/avia/components/AviaSearchResultsNoTransferFilter/AviaSearchResultsNoTransferFilter';

interface IAviaSearchResultsNoTransferFilterFilterNoConnectedProps
    extends IWithQaAttributes {
    isNewFilters?: boolean;
    transfersFilter: IUseAviaTransfersFilter;
    onChange?: () => void;
}

export const AviaSearchResultsNoTransferFilterFilterNoConnected: React.FC<IAviaSearchResultsNoTransferFilterFilterNoConnectedProps> =
    ({isNewFilters, transfersFilter, onChange, ...rest}) => {
        const {
            filter: {
                value: {value: flags},
                price,
            },
            handle,
        } = transfersFilter;
        const handleNoTransferChange = useCallback(() => {
            onChange?.();

            const value = isEnabled(
                flags,
                EAviaSearchTransferFilter.NO_TRANSFERS,
            )
                ? disable(flags, EAviaSearchTransferFilter.NO_TRANSFERS)
                : enable(flags, EAviaSearchTransferFilter.NO_TRANSFERS);

            handle(value);
        }, [flags, handle, onChange]);

        return (
            <AviaSearchResultsNoTransferFilter
                onChange={handleNoTransferChange}
                checked={isEnabled(
                    flags,
                    EAviaSearchTransferFilter.NO_TRANSFERS,
                )}
                price={price}
                isNewFilters={isNewFilters}
                {...prepareQaAttributes(rest)}
            />
        );
    };
