import {FC, useMemo} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-search';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import SortAscendingIcon from 'icons/16/SortAscending';
import FilterHeader from 'components/FiltersBottomSheet/components/FilterHeader/FilterHeader';

import AviaSearchResultsSortingFilterPopupConnected from './AviaSearchResultsSortingFilterPopupConnected';

import cx from './AviaSearchResultsSortingFilter.scss';

export interface IAviaSearchResultsSortingFilter extends IWithQaAttributes {
    isActive: boolean;
    onChange?: () => void;
}

const AviaSearchResultsSortingFilter: FC<IAviaSearchResultsSortingFilter> = ({
    isActive,
    onChange,
    ...rest
}) => {
    const label = useMemo(() => {
        return (
            <>
                <SortAscendingIcon className={cx('icon')} />
                {i18nBlock.filterDotSortingTitle()}
            </>
        );
    }, []);

    return (
        <DropdownFilter
            label={label}
            withArrowsIcon={false}
            checked={isActive}
            {...prepareQaAttributes(rest)}
        >
            <FilterHeader
                showResetButton={false}
                label={i18nBlock.filterDotSortingTitle()}
            />
            <AviaSearchResultsSortingFilterPopupConnected onChange={onChange} />
        </DropdownFilter>
    );
};

export default AviaSearchResultsSortingFilter;
