import {FC} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {useAviaSortingFilter} from 'projects/avia/hooks/useAviaSortingFilter';

import AviaSearchResultsSortingFilter from './AviaSearchResultsSortingFilter';

export interface IAviaSearchResultsSortingFilterConnectedProps
    extends IWithQaAttributes {
    onChange?: () => void;
}

const AviaSearchResultsSortingFilterConnected: FC<IAviaSearchResultsSortingFilterConnectedProps> =
    ({onChange, ...rest}) => {
        const {isActive} = useAviaSortingFilter();

        return (
            <AviaSearchResultsSortingFilter
                isActive={isActive}
                onChange={onChange}
                {...prepareQaAttributes(rest)}
            />
        );
    };

export default AviaSearchResultsSortingFilterConnected;
