import {ChangeEvent, FC, useCallback, useMemo} from 'react';

import {
    AVIA_SORTING_FILTER_ITEMS,
    AVIA_SORTING_FILTER_ITEMS_DEFAULT_PRICE_EXP,
    AVIA_SORTING_FILTER_VALUE_SEPARATOR,
} from 'projects/avia/components/AviaSearchResultsSortingFilter/constants';

import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {mapSortingToStringValue} from 'projects/avia/components/AviaSearchResultsSortingFilter/utils';
import {useExperiments} from 'utilities/hooks/useExperiments';

import Radiobox from 'components/Radiobox/Radiobox';
import {RadioOptionProps} from '@yandex-lego/components/Radiobox/Radiobox';

import {IUseAviaSortingFilter} from 'projects/avia/hooks/useAviaSortingFilter';

import cx from './AviaSearchResultsSortingFilterPopup.scss';

export interface IAviaSearchResultsSortingFilterPopupProps {
    sortingFilter: IUseAviaSortingFilter;
    onChange?: () => void;
}

const getItems = (isDefaultSortingPrice: boolean): RadioOptionProps[] =>
    (isDefaultSortingPrice
        ? AVIA_SORTING_FILTER_ITEMS_DEFAULT_PRICE_EXP
        : AVIA_SORTING_FILTER_ITEMS
    ).map(({label, ...rest}) => ({
        label,
        value: mapSortingToStringValue(rest),
    }));

export const AviaSearchResultsSortingFilterPopup: FC<IAviaSearchResultsSortingFilterPopupProps> =
    ({sortingFilter, onChange}) => {
        const {sorting, handleSortChange} = sortingFilter;
        const deviceType = useDeviceType();

        const {aviaDefaultSortPrice} = useExperiments();

        const handleOnChange = useCallback(
            (event: ChangeEvent<HTMLInputElement>) => {
                onChange?.();

                const [type, direction] = event.target.value.split(
                    AVIA_SORTING_FILTER_VALUE_SEPARATOR,
                ) as [EAviaResultsSortType, ESortDirection];

                handleSortChange({type, direction});
            },
            [handleSortChange, onChange],
        );

        const items = useMemo(
            () => getItems(Boolean(aviaDefaultSortPrice)),
            [aviaDefaultSortPrice],
        );

        const value = mapSortingToStringValue(sorting);

        return (
            <div className={cx('wrapper', deviceMods('wrapper', deviceType))}>
                <Radiobox
                    value={value}
                    onChange={handleOnChange}
                    options={items}
                    device={deviceType.isMobile ? 'touch' : 'desktop'}
                />
            </div>
        );
    };

export default AviaSearchResultsSortingFilterPopup;
