import {FC} from 'react';

import {useAviaSortingFilter} from 'projects/avia/hooks/useAviaSortingFilter';

import AviaSearchResultsSortingFilterPopup from './AviaSearchResultsSortingFilterPopup';

export interface IAviaSearchResultsSortingFilterPopupConnectedProps {
    onChange?: () => void;
}

const AviaSearchResultsSortingFilterPopupConnected: FC<IAviaSearchResultsSortingFilterPopupConnectedProps> =
    ({onChange}) => {
        const sortingFilter = useAviaSortingFilter();

        return (
            <AviaSearchResultsSortingFilterPopup
                sortingFilter={sortingFilter}
                onChange={onChange}
            />
        );
    };

export default AviaSearchResultsSortingFilterPopupConnected;
