import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';

import * as i18nBlock from 'i18n/avia-search';

const {ARRIVAL, DEPARTURE, PRICE, INTEREST, DURATION} = EAviaResultsSortType;

export const AVIA_SORTING_FILTER_VALUE_SEPARATOR = '|';

export const AVIA_SORTING_FILTER_ITEMS = [
    {
        label: i18nBlock.sortDotByDashInterest(),
        type: INTEREST,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashCheapest(),
        type: PRICE,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashExpensive(),
        type: PRICE,
        direction: ESortDirection.DESCENDING,
    },
    {
        label: i18nBlock.sortDotByDashDeparture(),
        type: DEPARTURE,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashArrival(),
        type: ARRIVAL,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashDuration(),
        type: DURATION,
        direction: ESortDirection.ASCENDING,
    },
];

export const AVIA_SORTING_FILTER_ITEMS_DEFAULT_PRICE_EXP = [
    {
        label: i18nBlock.sortDotByDashCheapest(),
        type: PRICE,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashInterest(),
        type: INTEREST,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashExpensive(),
        type: PRICE,
        direction: ESortDirection.DESCENDING,
    },
    {
        label: i18nBlock.sortDotByDashDeparture(),
        type: DEPARTURE,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashArrival(),
        type: ARRIVAL,
        direction: ESortDirection.ASCENDING,
    },
    {
        label: i18nBlock.sortDotByDashDuration(),
        type: DURATION,
        direction: ESortDirection.ASCENDING,
    },
];
