import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';

import AviaSearchResultsSortingSelect from './AviaSearchResultsSortingSelect';

export default {
    title: 'Avia/AviaSearchResultsSortingSelect',
    component: AviaSearchResultsSortingSelect,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState<[EAviaResultsSortType, ESortDirection]>([
        EAviaResultsSortType.PRICE,
        ESortDirection.ASCENDING,
    ]);

    return <AviaSearchResultsSortingSelect value={value} onChange={setValue} />;
};
