import React from 'react';

import {useAviaTimeFilter} from 'projects/avia/lib/hooks/filters/time';

import {AviaSearchTimeFilterNoConnected} from 'projects/avia/components/AviaSearchResultsTimeFilter/AviaSearchTimeFilterNoConnected';

interface IAviaSearchTimeFilterConnectedProps {
    isRoundtrip: boolean;
    wrapFilter(label: string, filter: React.ReactNode): React.ReactNode;

    separator?: React.ReactNode;
    onChange?: () => void; // Коллбэк на клик по чекбоксам
}

export const AviaSearchTimeFilterConnected: React.FC<IAviaSearchTimeFilterConnectedProps> =
    ({
        isRoundtrip,
        wrapFilter,

        separator = null,
        onChange,
    }) => {
        const timeFilter = useAviaTimeFilter();

        return (
            <AviaSearchTimeFilterNoConnected
                timeFilter={timeFilter}
                wrapFilter={wrapFilter}
                isRoundtrip={isRoundtrip}
                separator={separator}
                onChange={onChange}
            />
        );
    };
