import React, {useCallback} from 'react';

import {IAviaSearchTimeFilter} from 'reducers/avia/search/results/filters/reducer';

import {
    IUseAviaTimeFilter,
    useAviaTimeFilter,
} from 'projects/avia/lib/hooks/filters/time';

import {AviaTimeFilterPopup} from 'projects/avia/components/AviaSearchResultsTimeFilter/AviaTimeFilterPopup';

import {getTimeFilterConfigByDirection} from './getTimeFilterConfigByDirection';

interface IAviaSearchTimeFilterNoConnectedProps {
    isRoundtrip: boolean;
    wrapFilter(label: string, filter: React.ReactNode): React.ReactNode;

    separator?: React.ReactNode;
    /** Коллбэк на клик по чекбоксам */
    onChange?: () => void;
    timeFilter: IUseAviaTimeFilter;
}

export const AviaSearchTimeFilterNoConnected: React.FC<IAviaSearchTimeFilterNoConnectedProps> =
    ({
        isRoundtrip,
        wrapFilter,

        separator = null,
        onChange,
        timeFilter,
    }) => {
        const {handle} = timeFilter;

        const onFilterChange = useCallback(
            (segmentVal: IAviaSearchTimeFilter, segmentIdx: number) => {
                handle(segmentVal, segmentIdx);

                if (onChange) {
                    onChange();
                }
            },
            [handle, onChange],
        );

        return (
            <>
                {renderFilter(
                    'forward',
                    timeFilter,
                    wrapFilter,
                    onFilterChange,
                )}
                {isRoundtrip && separator}
                {isRoundtrip &&
                    renderFilter(
                        'backward',
                        timeFilter,
                        wrapFilter,
                        onFilterChange,
                    )}
            </>
        );
    };

function renderFilter(
    direction: 'forward' | 'backward',
    timeFilter: ReturnType<typeof useAviaTimeFilter>,
    wrapFilter: IAviaSearchTimeFilterNoConnectedProps['wrapFilter'],
    onChange: (segmentVal: IAviaSearchTimeFilter, segmentIdx: number) => void,
): React.ReactNode {
    const {label, segmentIdx} = getTimeFilterConfigByDirection(direction);
    const {
        filter: {value, viewData},
    } = timeFilter;

    return wrapFilter(
        label,
        <AviaTimeFilterPopup
            segmentIdx={segmentIdx}
            disabled={
                viewData.disabled[segmentIdx] ||
                ({arrival: 0, departure: 0} as IAviaSearchTimeFilter)
            }
            value={
                value[segmentIdx] ||
                ({arrival: 0, departure: 0} as IAviaSearchTimeFilter)
            }
            onChange={onChange}
        />,
    );
}
