import React, {useCallback} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';
import {useAviaAirportsFilter} from 'projects/avia/lib/hooks/filters/airports';

import * as i18nBlock from 'i18n/avia-search';

import DropdownFilter from 'components/DropdownFilter/DropdownFilter';
import FilterHeader from 'components/FiltersBottomSheet/components/FilterHeader/FilterHeader';

import {AviaTransferFilterPopupNoConnected} from './AviaTransferFilterPopupNoConnected';

import cx from './AviaSearchResultsTransferFilter.scss';

interface IAviaSearchResultsTransferFilter extends IWithQaAttributes {
    isActive: boolean;
    hideRange?: boolean;
    hideTransferAirports?: boolean;
    showHeader?: boolean;
    onChange?: () => void;
}

const AviaSearchResultsTransferFilter: React.FC<IAviaSearchResultsTransferFilter> =
    ({
        isActive,
        hideRange,
        hideTransferAirports,
        showHeader,
        onChange,
        ...rest
    }) => {
        const transfersFilter = useAviaTransfersFilter();
        const airportsFilter = useAviaAirportsFilter();

        const resetTransfer = useCallback(() => {
            onChange?.();

            airportsFilter.resetTransferAirports();
            transfersFilter.reset();
        }, [onChange, airportsFilter, transfersFilter]);

        return (
            <DropdownFilter
                popupClassName={cx('popup')}
                checked={isActive}
                label={i18nBlock.filterDotTransfersDashPlaceholder()}
                {...prepareQaAttributes(rest)}
            >
                {showHeader && (
                    <FilterHeader
                        label={i18nBlock.filterDotTransfersDashPlaceholder()}
                        buttonResetDisabled={
                            !transfersFilter.filter.isActive &&
                            !airportsFilter.filter.transfersIsActive
                        }
                        onReset={resetTransfer}
                    />
                )}
                <AviaTransferFilterPopupNoConnected
                    hideRange={hideRange}
                    hideTransferAirports={hideTransferAirports}
                    transfersFilter={transfersFilter}
                    airportsFilter={airportsFilter}
                    onChange={onChange}
                />
            </DropdownFilter>
        );
    };

export default React.memo(AviaSearchResultsTransferFilter);
