import {IResultAviaStation} from 'selectors/avia/utils/denormalization/station';

export interface IAviaCityDirectionGroup {
    title: string;
    code: string;
    stations: IResultAviaStation[];
}

export function preparedCities(
    stations: IResultAviaStation[],
): IAviaCityDirectionGroup[] {
    const idToStations = stations.reduce((acc, station) => {
        const id = station.settlement?.id || station.id;

        if (id in acc) {
            acc[id].push(station);
        } else {
            acc[id] = [station];
        }

        return acc;
    }, {} as Record<string, IResultAviaStation[]>);

    return Object.values(idToStations)
        .map(groupedStations => {
            const station = groupedStations[0];

            return {
                title: station.settlement?.title || station.title,
                code: station.settlement?.code || station.code,
                stations: groupedStations,
            };
        })
        .sort((lhs, rhs) => {
            if (lhs.title < rhs.title) {
                return -1;
            }

            if (lhs.title > rhs.title) {
                return 1;
            }

            return 0;
        });
}
