import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import {Flag} from 'utilities/flags/flags';
import {useAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';
import {useAviaAirportsFilter} from 'projects/avia/lib/hooks/filters/airports';

import {AviaTransferFilterPopupNoConnected} from 'projects/avia/components/AviaSearchResultsTransferFilter/AviaTransferFilterPopupNoConnected';

interface IAviaTransferFilterPopupConnectedProps {
    hideRange?: boolean;
    hideTransferAirports?: boolean;
    onChangeCheckbox?: (newValue: Flag<EAviaSearchTransferFilter>) => void; // Обработчик на клик по чекбоксу
}

export function AviaTransferFilterPopupConnected({
    hideRange,
    hideTransferAirports,
    onChangeCheckbox,
}: IAviaTransferFilterPopupConnectedProps) {
    const transfersFilter = useAviaTransfersFilter();
    const airportsFilter = useAviaAirportsFilter();

    return (
        <AviaTransferFilterPopupNoConnected
            hideRange={hideRange}
            hideTransferAirports={hideTransferAirports}
            onChangeCheckbox={onChangeCheckbox}
            transfersFilter={transfersFilter}
            airportsFilter={airportsFilter}
        />
    );
}
