import {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {setTransferRangeFilter} from 'reducers/avia/search/results/filters/actions';
import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import {Flag} from 'utilities/flags/flags';
import {EAviaRumEvents} from 'projects/avia/lib/EAviaRumEvents';
import {IUseAviaTransfersFilter} from 'projects/avia/lib/hooks/filters/transfers';
import {IUseAviaAirportsFilter} from 'projects/avia/lib/hooks/filters/airports';

import {useRumUi} from 'contexts/RumUiContext';

import {AviaTransferFilterPopup} from './AviaTransferFilterPopup/AviaTransferFilterPopup';

interface IAviaTransferFilterPopupNoConnectedProps {
    hideRange?: boolean;
    hideTransferAirports?: boolean;
    onChangeCheckbox?: (newValue: Flag<EAviaSearchTransferFilter>) => void; // Обработчик на клик по чекбоксу
    transfersFilter: IUseAviaTransfersFilter;
    airportsFilter: IUseAviaAirportsFilter;
    onChange?: () => void;
}

export function AviaTransferFilterPopupNoConnected({
    hideRange,
    hideTransferAirports,
    onChangeCheckbox,
    transfersFilter,
    airportsFilter,
    onChange,
}: IAviaTransferFilterPopupNoConnectedProps) {
    const dispatch = useDispatch();
    const rumUi = useRumUi();

    const handleChangeCheckbox = useCallback(
        (newValue: Flag<EAviaSearchTransferFilter>) => {
            onChange?.();

            transfersFilter.handle(newValue);

            if (onChangeCheckbox) {
                onChangeCheckbox(newValue);
            }
        },
        [onChange, transfersFilter, onChangeCheckbox],
    );

    const handleRangeChange = useCallback(
        (val: [number, number]) => {
            if (Number.isFinite(val[0]) && Number.isFinite(val[1])) {
                onChange?.();

                rumUi.measure(EAviaRumEvents.Filter);
                dispatch(setTransferRangeFilter(val));
            }
        },
        [dispatch, onChange, rumUi],
    );

    return (
        <AviaTransferFilterPopup
            hideRange={Boolean(hideRange)}
            hideTransferAirports={Boolean(hideTransferAirports)}
            hasTransfers={transfersFilter.filter.viewData.hasTransfers}
            transfersValue={transfersFilter.filter.value.value}
            transfersDisabled={transfersFilter.filter.viewData.disabled}
            onChangeTransfers={handleChangeCheckbox}
            range={transfersFilter.filter.value.range}
            minDuration={transfersFilter.filter.viewData.minDuration}
            maxDuration={transfersFilter.filter.viewData.maxDuration}
            onRangeChange={handleRangeChange}
            airportsFilter={airportsFilter}
            onAirportsChange={onChange}
        />
    );
}
