import React from 'react';

import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import Checkbox from 'components/Checkbox/Checkbox';

export interface ITransferFilterCheckboxProps {
    value: EAviaSearchTransferFilter;
    label: string;
    checked: boolean;
    disabled?: boolean;
    onChange(checked: boolean, value: EAviaSearchTransferFilter): void;
    children?: never;
}

import cx from './TransferFilterCheckbox.scss';

export function TransferFilterCheckbox({
    disabled,
    label,
    onChange,
    checked,
    value,
}: ITransferFilterCheckboxProps) {
    const handleChange = React.useCallback(
        ({target}) => onChange(target.checked, value),
        [onChange, value],
    );

    return (
        <Checkbox
            className={cx('root')}
            onChange={handleChange}
            checked={checked}
            disabled={disabled}
            label={label}
        />
    );
}
