import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import * as keyset from 'i18n/avia-search';

const {EXCLUDE_NIGHTLY, NO_AIRPORT_CHANGE, NO_TRANSFERS, ONE_CHANGE} =
    EAviaSearchTransferFilter;

export const AVIA_TRANSFER_FILTER_NO_TRANSFERS = {
    value: NO_TRANSFERS,
    label: keyset.filterDotNoDashTransfers(),
};
export const AVIA_TRANSFER_FILTERS_REST_ITEMS = [
    {value: ONE_CHANGE, label: keyset.filterDotOneDashChange()},
    {value: EXCLUDE_NIGHTLY, label: keyset.filterDotExcludeDashNightly()},
    {
        value: NO_AIRPORT_CHANGE,
        label: keyset.filterDotNoDashAirportDashChange(),
    },
];
