import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {subscribe} from 'reducers/avia/search/subscription/thunk';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {useUserInfo} from 'utilities/hooks/useUserInfo';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import * as i18nBlock from 'i18n/avia-subscription';

import SubscriptionModal from 'components/SubscriptionModal/SubscriptionModal';

interface IAviaSearchSubscribeModalProps {
    isVisible: boolean;
    onClose: () => void;
}

const AviaSearchSubscribeModal: React.FC<IAviaSearchSubscribeModalProps> = ({
    isVisible,
    onClose,
}) => {
    const dispatch = useDispatch();
    const userInfo = useUserInfo();

    const subscribeHandler = useCallback(
        async (email: string) => {
            await dispatch(subscribe(email));
        },
        [dispatch],
    );

    return (
        <SubscriptionModal
            title={insertJSXIntoKey(i18nBlock.commonDashModalDashTitle)({
                separator: <br />,
            })}
            text={null}
            disclaimer={i18nBlock.commonDashModalDashDescription()}
            inputPlaceholder={i18nBlock.commonDashModalDashPlaceholder()}
            submitButton={i18nBlock.commonDashModalDashButton()}
            isVisible={isVisible}
            email={isAuthUser(userInfo) ? userInfo.contacts.email : undefined}
            onClose={onClose}
            onSubmit={subscribeHandler}
        />
    );
};

export default AviaSearchSubscribeModal;
