import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'src/components/Box/Box';
import Heading from 'src/components/Heading/Heading';
import BaggageIcon from 'icons/16/Baggage';
import HandLuggageIcon from 'icons/16/HandLuggage';

import BaggageFormatter from './BaggageFormatter';

export default {
    title: 'Avia/BaggageFormatter',
    component: BaggageFormatter,
} as Meta;

const weight = 23;
const size = '40x30x15';

export const ShowNoBaggage: TStorybookFunctionComponent = () => (
    <Box>
        <Heading level={3}>0 places</Heading>
        <BaggageFormatter
            showNoBaggage
            places={0}
            weight={weight}
            icon={<BaggageIcon />}
        />
    </Box>
);

export const PlacesAndWeight: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatter
                        places={places}
                        weight={weight}
                        icon={<BaggageIcon />}
                    />
                </div>
            );
        })}
    </Box>
);

export const PlacesAndSizeAndWeight: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatter
                        places={places}
                        weight={weight}
                        size={size}
                        icon={<HandLuggageIcon />}
                    />
                </div>
            );
        })}
    </Box>
);

export const PlacesAndSize: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatter
                        places={places}
                        size={size}
                        icon={<HandLuggageIcon />}
                    />
                </div>
            );
        })}
    </Box>
);
