import React, {ReactNode} from 'react';

import BaggageFormatterBasic, {
    IBaggageFormatterBasicProps,
} from 'projects/avia/components/BaggageFormatterBasic/BaggageFormatterBasic';

import cx from './BaggageFormatter.scss';

interface IBaggageFormatterProps extends IBaggageFormatterBasicProps {
    icon?: ReactNode;
}

const BaggageFormatter: React.FC<IBaggageFormatterProps> = props => {
    const {places, icon} = props;

    return (
        <BaggageFormatterBasic {...props}>
            {icon && <span className={cx('icon')}>{icon}</span>}
            {icon && ' '}
            {Boolean(places && places > 1) && <span>{places} x </span>}
        </BaggageFormatterBasic>
    );
};

export default BaggageFormatter;
