import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'src/components/Box/Box';
import Heading from 'src/components/Heading/Heading';

import BaggageFormatterBasic from './BaggageFormatterBasic';

export default {
    title: 'Avia/BaggageFormatterBasic',
    component: BaggageFormatterBasic,
} as Meta;

const weight = 23;
const size = '40x30x15';

export const ShowNoBaggage: TStorybookFunctionComponent = () => (
    <Box>
        <div>
            <Heading level={3}>0 places</Heading>
            <BaggageFormatterBasic showNoBaggage places={0} weight={weight} />
        </div>
    </Box>
);

export const WeightAndSize: TStorybookFunctionComponent = () => (
    <Box>
        <div>
            <Heading level={3}>1 place</Heading>
            <BaggageFormatterBasic places={1} weight={weight} size={size} />
        </div>
    </Box>
);

export const Weight: TStorybookFunctionComponent = () => (
    <Box>
        <div>
            <Heading level={3}>1 place</Heading>
            <BaggageFormatterBasic places={1} weight={weight} />
        </div>
    </Box>
);
