import React from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlockCommonUnits from 'i18n/common-units';
import * as aviaFlightFareTermsFormattersI18nBlock from 'i18n/avia-flightFareTerms-formatters';

export interface IBaggageFormatterBasicProps extends IWithQaAttributes {
    places?: number;
    weight?: number;
    size?: string;
    showNoBaggage?: boolean;
}

const BaggageFormatterBasic: React.FC<IBaggageFormatterBasicProps> = props => {
    const {weight, places, size, children, showNoBaggage} = props;

    if (!places) {
        return showNoBaggage ? (
            <span {...prepareQaAttributes(props)}>
                {children}
                <span>
                    {aviaFlightFareTermsFormattersI18nBlock.noDashBaggage()}
                </span>
            </span>
        ) : null;
    }

    const formattedSize = size && i18nBlockCommonUnits.cmValue({value: size});
    const formattedWeight =
        weight && i18nBlockCommonUnits.kgValue({value: weight});

    return (
        <span {...prepareQaAttributes(props)}>
            {children}
            {formattedWeight}
            {size && weight && ', '}
            {formattedSize}
        </span>
    );
};

export default BaggageFormatterBasic;
