import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'src/components/Box/Box';
import Heading from 'src/components/Heading/Heading';

import BaggageFormatterVerbose from './BaggageFormatterVerbose';

export default {
    title: 'Avia/BaggageFormatterVerbose',
    component: BaggageFormatterVerbose,
} as Meta;

const weight = 23;
const size = '40x30x15';

export const PlacesAndWeight: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2, 5].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatterVerbose places={places} weight={weight} />
                </div>
            );
        })}
    </Box>
);

export const PlacesAndSizeAndWeight: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2, 5].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatterVerbose
                        places={places}
                        weight={weight}
                        size={size}
                    />
                </div>
            );
        })}
    </Box>
);

export const PlacesAndSize: TStorybookFunctionComponent = () => (
    <Box>
        {[0, 1, 2, 5].map(places => {
            return (
                <div key={places}>
                    <Heading level={3}>{places} places</Heading>
                    <BaggageFormatterVerbose places={places} size={size} />
                </div>
            );
        })}
    </Box>
);
