import React from 'react';

import * as i18nBlockCommonUnits from 'i18n/common-units';

import BaggageFormatterBasic, {
    IBaggageFormatterBasicProps,
} from 'projects/avia/components/BaggageFormatterBasic/BaggageFormatterBasic';

interface IBaggageFormatterVerboseProps extends IBaggageFormatterBasicProps {}

const BaggageFormatterVerbose: React.FC<IBaggageFormatterVerboseProps> =
    props => {
        const {places} = props;

        return (
            <BaggageFormatterBasic {...props}>
                {places
                    ? `${i18nBlockCommonUnits.placesValue({
                          value: places,
                      })}, `
                    : ''}
            </BaggageFormatterBasic>
        );
    };

export default BaggageFormatterVerbose;
